#ifndef WEIGHTEDPOINT_H
#define WEIGHTEDPOINT_H

#include "Point.hpp"

/**
 * @brief Weighted point class
 */
class WeightedPoint : public Point
{
public:
	// constructors
	WeightedPoint();
	WeightedPoint(WeightedPoint const & point) = default;
	WeightedPoint(Point const & point);
	WeightedPoint(std::vector<double> const & coordinates);
	WeightedPoint(std::vector<double> const & coordinates, double weight);

	// accessors / mutators
	void setWeight(double weight);
	double getWeight() const;

private:
	double weight;
};

std::ostream& operator<<(std::ostream& stream, WeightedPoint const& point);

#endif
