#ifndef DATASTREAMCORESET_HPP
#define	DATASTREAMCORESET_HPP

#include <iterator>

#include "MergeReduce.hpp"
#include "ProbabilisticPoint.hpp"
#include "FastCoreset.hpp"

/**
 * @brief Wraps FastCoreset into the Merge & Reduce framework
 */
class DatastreamCoreset : public MergeReduce<ProbabilisticPoint>
{
private:
    FastCoreset * fastCoreset;
public:
    /**
     * @param fastCoreset FastCoreset instance to be wrapped
     * @param firstBucketSize Merge & Reduce bucket size
     */
    DatastreamCoreset(FastCoreset * fastCoreset, int firstBucketSize) :
    fastCoreset(fastCoreset),
    MergeReduce(firstBucketSize)
    {
    }

    virtual ~DatastreamCoreset()
    {
    }
private:
    virtual void reduce(std::vector<ProbabilisticPoint> const * input, int level, std::vector<ProbabilisticPoint> * reduced);
};

#endif	/* DATASTREAMCORESET_HPP */

