#ifndef CENTERGRAVITY_H
#define CENTERGRAVITY_H

#include <functional>
#include <algorithm>
#include <limits>

#include "Point.hpp"
#include "Metric.hpp"

/**
 * @brief Computes the center of gravity / centroid / 1-means
 */
class CenterOfGravity
{
public:
    CenterOfGravity(std::function<Metric<Point>*() > createMetric);

    /**
     * @brief Computes the center of gravity / centroid / 1-means
     * @param begin Input point set iterator: begin
     * @param end Input point set iterator: end
     * @return Center of gravity
     */
    template<typename ForwardIterator>
    Point cog(ForwardIterator begin, ForwardIterator end);

private:
    Metric<Point>* metric;
};

template<typename ForwardIterator>
Point CenterOfGravity::cog(ForwardIterator begin, ForwardIterator end)
{
    Point cog = *begin;
    ++begin;
    double n = 1;
    for (; begin != end; ++begin)
    {
        cog += *begin;
        ++n;
        ;
    }
    cog = (1.0 / n) * cog;
    return cog;
}

#endif
